﻿function bulkResolveRequestsHEC(selectedItems) {
    // loop through selected item

    for (i = 0; i < selectedItems.length; i++) {
        var selectedItem = selectedItems[i];
        var remainingItems = selectedItems.length;

        // Call action (action will stop if LOB is not correct)
        callAction("vhacrm_RequestHECResolve",
            [{
                key: "Target",
                type: "a:EntityReference",
                value: selectedItem
            }],
            function () { //SUCCESS CALLBACK
                remainingItems--;
                if (remainingItems == 0) {
                    //if (crmGrid) {
                    //    crmGrid.refresh();
                    //}
                    window.location = window.location;
                }
            },
            function (e, t) { //ERROR CALLBACK
                // Error
                alert(e);
            }
        );
    }
}

function enableBulkResolveButtonHEC() {
    var enableButton = false;
    var teamid = "C8CCF913-8F90-E611-8124-127B25DCBDE7";

    // Check if EED Supervisor
    var userid = Xrm.Page.context.getUserId();
    enableButton = isUserOnTeam(userid, teamid);

    return enableButton;
}

//copied from here - https://processjs.codeplex.com/
function callAction(actionName, inputParams, successCallback, errorCallback) {
    var url = Xrm.Page.context.getClientUrl();

    var requestXml = "<s:Envelope xmlns:s='http://schemas.xmlsoap.org/soap/envelope/'>" +
		  "<s:Body>" +
			"<Execute xmlns='http://schemas.microsoft.com/xrm/2011/Contracts/Services' xmlns:i='http://www.w3.org/2001/XMLSchema-instance'>" +
			  "<request xmlns:a='http://schemas.microsoft.com/xrm/2011/Contracts'>" +
				"<a:Parameters xmlns:b='http://schemas.datacontract.org/2004/07/System.Collections.Generic'>";

    if (inputParams) {
        // Add each input param
        for (var i = 0; i < inputParams.length; i++) {
            var param = inputParams[i];

            var value = "";
            var displayXmlns = false;

            // Check the param type to determine how the value is formed
            switch (param.type) {
                case "c:boolean":
                case "c:int":
                    value = param.value;
                    displayXmlns = true;
                    break;
                case "c:dateTime":
                    value = param.value.toISOString();
                    displayXmlns = true;
                    break;
                    /* case "a:EntityReference":
                         value = "<a:Id>" + param.value.id + "</a:Id>" +
                           "<a:LogicalName>" + param.value.entityType + "</a:LogicalName>" +
                           "<a:Name i:nil='true' />";
                         break; */
                case "a:EntityReference":
                    value = "<a:Id>" + param.value.Id + "</a:Id>" +
                      "<a:LogicalName>" + param.value.TypeName + "</a:LogicalName>" +
                      "<a:Name i:nil='true' />";
                    break;
                case "a:Entity":
                    value = "<a:Id>" + param.value.Id + "</a:Id>" +
                      "<a:LogicalName>" + param.value.TypeName + "</a:LogicalName>" +
                      "<a:Name i:nil='true' />";
                    break;
                case "a:OptionSetValue":
                case "a:Money":
                    value = "<a:Value>" + param.value + "</a:Value>";
                    break;
                default:
                    if (errorCallback) {
                        errorCallback("Type of input parameter " + (i + 1) + " '" + param.type + "' is invalid or unsupported");
                    }
                    return;
                    break;
            }

            requestXml += "<a:KeyValuePairOfstringanyType>" +
					"<b:key>" + param.key + "</b:key>" +
					"<b:value i:type='" + param.type + "' " + (displayXmlns ? "xmlns:c='http://www.w3.org/2001/XMLSchema'" : "") + ">" + value + "</b:value>" +
				  "</a:KeyValuePairOfstringanyType>";
        }
    }

    requestXml += "</a:Parameters>" +
				"<a:RequestId i:nil='true' />" +
				"<a:RequestName>" + actionName + "</a:RequestName>" +
			  "</request>" +
			"</Execute>" +
		  "</s:Body>" +
		"</s:Envelope>";

    var req = new XMLHttpRequest();
    req.open("POST", url + "/XRMServices/2011/Organization.svc/web", true);
    req.setRequestHeader("Accept", "application/xml, text/xml, */*");
    req.setRequestHeader("Content-Type", "text/xml; charset=utf-8");
    req.setRequestHeader("SOAPAction", "http://schemas.microsoft.com/xrm/2011/Contracts/Services/IOrganizationService/Execute");

    req.onreadystatechange = function () {
        if (req.readyState == 4) {
            if (req.status == 200) {
                // Action completed successfully - get output params
                var responseParams = req.responseXML.getElementsByTagName("a:KeyValuePairOfstringanyType"); // IE
                if (responseParams.length == 0) {
                    responseParams = req.responseXML.getElementsByTagName("KeyValuePairOfstringanyType"); // FireFox and Chrome
                }

                var outputParams = [];
                for (i = 0; i < responseParams.length; i++) {

                    var attrNameNode = responseParams[i].childNodes[0].firstChild;
                    var attributeName = attrNameNode.textContent || attrNameNode.nodeValue || attrNameNode.data || attrNameNode.text;

                    var attributeValue = "";
                    if (responseParams[i].childNodes[1].firstChild != null) {
                        var attrValueNode = responseParams[i].childNodes[1].firstChild;
                        attributeValue = attrValueNode.textContent || attrValueNode.nodeValue || attrValueNode.data || attrValueNode.text;
                    }

                    // Values will be string, figure out the types yourself
                    outputParams.push({ key: attributeName, value: attributeValue });

                    /*
					DateTime = "2015-06-23T21:00:00Z" (AS UTC STRING)
					bool = "true" (AS STRING)
					OptionSet, int, etc = "1" (AS STRING)
					*/
                }

                if (successCallback) {
                    // Make sure the callback accepts exactly 1 argument - use dynamic function if you want more
                    successCallback(outputParams);
                }
            }
            else {
                // Error has occured, action failed
                if (errorCallback) {
                    var error = null;
                    try { error = req.responseXML.getElementsByTagName("Message")[0].firstChild.nodeValue; } catch (e) { }
                    errorCallback(error);
                }
            }
        }
    };

    req.send(requestXml);
}

//check if the user is on the team using a synchronous odata call
function isUserOnTeam(userid, teamid) {
    var returnvalue = false;
    var oDataSetName = "TeamMembershipSet";
    var filter = "SystemUserId eq guid' " + userid + " ' and TeamId eq guid' " + teamid + "'";
    var columns = "*";
    var requestResults = retrieveMultipleSync(oDataSetName, columns, filter);

    if (requestResults != null) {
        if (requestResults.results.length > 0) {
            returnvalue = true;
        }
    }
    return returnvalue;
}

//helper function for making sync odata calls
function retrieveMultipleSync(odataSetName, select, filter) {
    // Get Server URL
    var serverUrl = "";
    if (Xrm.Page.context.getClientUrl) {
        //Post UR 12
        serverUrl = Xrm.Page.context.getClientUrl();
    }
    else {
        //Pre UR 12
        serverUrl = Xrm.Page.context.getServerUrl();
    }
    var ODATA_ENDPOINT = "/XRMServices/2011/OrganizationData.svc";
    var odataUri = serverUrl + ODATA_ENDPOINT + "/" + odataSetName + "?";
    if (select) {
        odataUri += "$select=" + select;
    }
    if (filter) {
        odataUri += "&" + "$filter=" + filter;
    }
    var service = getRequestObject();
    if (service != null) {
        service.open("GET", odataUri, false);
        service.setRequestHeader("X-Requested-Width", "XMLHttpRequest");
        service.setRequestHeader("Accept", "application/json,text/javascript, */*");
        service.send(null);
        var requestResults = eval('(' + service.responseText + ')').d;
        return requestResults;
    }
}

//helper function for making xmlhttp requests
function getRequestObject() {
    if (window.XMLHttpRequest) {
        return new window.XMLHttpRequest;
    }
    else {
        try {
            return new ActiveXObject("MSXML2.XMLHTTP.3.0");
        }
        catch (ex) {
            return null;
        }
    }
}

function bulkResolveRequestsHD(selectedItems) {
    var todaysDate = new Date();
    todaysDate = (todaysDate.getMonth() + 1) + "/" + todaysDate.getDate() + "/" + todaysDate.getFullYear();
    var bulk_entityObject = new Object();
    bulk_entityObject.vhacrm_name = "Bulk Resolve on " + todaysDate;
    bulk_entityObject.vhacrm_lobid = { Id: '{1BD4B15A-BFBB-E511-9414-0050568DC724}', LogicalName: "vhacrm_lob", Name: "vhacrm_lobid" };

    var bulk_requests = new Array();

    if (checkForHDLob(selectedItems) == false) {
        errormsg = true;
        alert("You have selected a request that is not a Help Desk request.  Please only select Help Desk requests.");
    }
    else {
        for (i = 0; i < selectedItems.length; i++) {
            var selectedItem = selectedItems[i];
            var requestObject = new Object();
            requestObject.vhacrm_requestid = { Id: selectedItem.Id, LogicalName: "vhacrm_bulkresolution", Name: "vhacrm_requestid" };
            bulk_requests.push(requestObject);
        }

        bulk_entityObject.vhacrm_vhacrm_bulkresolution_vhacrm_bulkresolutionintersection_bulkresolutionid = bulk_requests;

        var jsonEntity = window.JSON.stringify(bulk_entityObject);
        var bulk_entityCollection = "vhacrm_bulkresolutionSet";
        var bulk_context = Xrm.Page.context;
        var serverUrl = bulk_context.getClientUrl();
        var oDataEndPoint = '/XRMServices/2011/OrganizationData.svc';
        var odataUri = serverUrl + oDataEndPoint + "/" + bulk_entityCollection;

        $.ajax({
            type: "POST",
            contentType: "application/json; charset=utf-8",
            datatype: "json",
            url: odataUri,
            data: jsonEntity,
            async: true,
            beforeSend: function (XMLHttpRequest) {
                XMLHttpRequest.setRequestHeader("Accept", "application/json");
            },
            success: function (data, textStatus, XmlHttpRequest) {
                Xrm.Utility.openEntityForm("vhacrm_bulkresolution", data.d.vhacrm_bulkresolutionId);
            },
            error: function (XmlHttpRequest, textStatus, errorThrown) {
                alert('Fail: Ajax Error in bulkResolveRequests: ' + errorThrown);
            }
        });
    }
}

function checkForHDLob(requests) {
    var reqlob = '';
    var hdlob = '1BD4B15A-BFBB-E511-9414-0050568DC724';
    var filter = '';
    for (i = 0; i < requests.length; i++) {
        var selectedItem = requests[i];
        filter += "IncidentId eq guid'" + selectedItem.Id + "'";
        if (i != (requests.length-1)) {
            filter += " or ";
        }
    }

    var returnvalue = false;
    var oDataSetName = "IncidentSet";
    var columns = "*";
    var requestResults = retrieveMultipleSync(oDataSetName, columns, filter);
    if (requestResults) {
        if (requestResults.results.length > 0) {
            for (i = 0; i < requestResults.results.length; i++) {
                var request = requestResults.results[i];
                reqlob = request.vhacrm_lobid.Id.toUpperCase();
                if (reqlob == hdlob) {
                    returnvalue = true;
                }
                else {
                    returnvalue = false;
                    i = requestResults.results.length;
                }
            }
        }
        else {
            returnvalue = false;
        }
    }
    return returnvalue;
}

function enableBulkResolveButtonHD() {
    var enableButton = false;
    var currentUserRoles = Xrm.Page.context.getUserRoles();
    for (var i = 0; i < currentUserRoles.length; i++) {
        var userRoleId = currentUserRoles[i];
        var userRoleName = GetRoleName(userRoleId);
        if (userRoleName == "System Administrator" || userRoleName == "HRC - Admin" || userRoleName == "HRC - HD Tier 2" || userRoleName == "HRC - HD Supervisor") {
            enableButton = true;
        }
    }
    return enableButton;
}
//Get Rolename based on RoleId
function GetRoleName(roleId) {
    //var serverUrl = Xrm.Page.context.getServerUrl();
    var serverUrl = location.protocol + "//" + location.host + "/" + Xrm.Page.context.getOrgUniqueName();
    var odataSelect = serverUrl + "/XRMServices/2011/OrganizationData.svc" + "/" + "RoleSet?$filter=RoleId eq guid'" + roleId + "'";
    var roleName = null;
    $.ajax(
        {
            type: "GET",
            async: false,
            contentType: "application/json; charset=utf-8",
            datatype: "json",
            url: odataSelect,
            beforeSend: function (XMLHttpRequest) { XMLHttpRequest.setRequestHeader("Accept", "application/json"); },
            success: function (data, textStatus, XmlHttpRequest) {
                roleName = data.d.results[0].Name;
            },
            error: function (XmlHttpRequest, textStatus, errorThrown) { alert('OData Select Failed: ' + textStatus + errorThrown + odataSelect); }
        }
    );
    return roleName;
}
